///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems, Inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

//-------------------
function NQWAppendFilter(tColumnDef)
{
   // Because column can come from another frame we put the current window's functions on it
   NQWColumnDef_AssignFunctions(tColumnDef);

   var tEditor = XUIPanel.getEditor('idFilter');

   // Update the column space
   var tInfo = XUIColumnSpace.findInfo(null, tColumnDef.GetSQLFormula());
   if (tInfo == null)
      tInfo = XUIColumnSpace.addColumnInfo(tColumnDef, null);

   tEditor.addFilterFromFormula(tInfo.getAttribute("formula"));
}

var sFilterCaption = null;
var tColumnInfoRequests = null;

///////////////////////////////////////////////////////////////////////////////
// FilterEditor
///////////////////////////////////////////////////////////////////////////////

//-------------------
function FilterEditor(eid, bIsListFormat, prefixID)
{
   this.form = document.forms[eid + 'Form'];

   this.prefixID = prefixID;
   if (this.prefixID == null)
      this.prefixID = 'idFilter';

   this.htmlTable = document.getElementById(this.prefixID + 'Table');
   this.links = document.getElementById(this.prefixID + 'Links');
   this.clipboard = null;
   this.bAllowEditFormula = true;

   if (this.htmlTable == null)
      alert('Filter Editor Template not found on page');

   if (null != bIsListFormat && bIsListFormat == true)
   {
      this.eid = eid;
      this.bIsListFormat = true;
      this.listFormatForm = document.forms[eid + 'ListFormatForm'];

      this.listFormatRequalifyTable = document.getElementById ('idListFormatRequalifyTable');
      this.listFormatRequalifyTable.style.display = 'none';

      this.listRequalifyCheckErrorTable = document.getElementById ("idListFormatRequalifyCheckErrorTable");
      this.listRequalifyCheckErrorTable.style.display = 'none';

      this.listRequalifyCheckErrorCell = document.getElementById (eid + "ListRequalifyCheckError");

      this.requalifyConfirmDlg = new MktgConfirmDialog ('idRequalifyConfirmDlg', this.eid);
   }

   var tApplyFilterEditor = new ApplyFilterEditor('idFilterApply');
   this.filterApplyPanel = new XUIInline('idFilterApply',tApplyFilterEditor,this);
}

FilterEditor.prototype = new XUIEditor();

//-------------------
// Static Method
FilterEditor.appendExpr = function(tParent, sTypeNS, sType, sOp)
{
   var tExpr = XUIAppendNewElement(tParent, saw.xml.kSawxNamespace, 'expr');
   XUISetXsiType(tExpr, sTypeNS, sType);
   if (sOp != null)
      tExpr.setAttribute("op", sOp);

   return tExpr;
}

//-------------------
FilterEditor.prototype.getFilterElement = function(bForce)
{
   var tFilter = this.criteria.selectSingleNode("saw:filter");
   if ((tFilter == null) && bForce)
   {
      tFilter = XUIAppendNewElement(this.criteria, saw.xml.kSawNamespace, 'filter');
   }

   if (tFilter != null) // ensure namespaces
   {
   //adds duplicate in mozilla since getAttribute does not work properly!
/*      if (tFilter.getAttribute("xmlns:saw") == null)
      {
         tFilter.setAttribute("xmlns:saw", "com.siebel.analytics.web/report/v1");
      }*/
      if (tFilter.getAttribute("xmlns:xsi") == null)
         tFilter.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
      if (tFilter.getAttribute("xmlns:sawx") == null)
         tFilter.setAttribute("xmlns:sawx", "com.siebel.analytics.web/expression/v1");

      try
      {
      // GTSO, will this ever succceed? doesn't seem like we are storing subjectARea on criteria node
         if(tFilter.getAttribute("subjectArea") == null)
            tFilter.setAttribute("subjectArea",this.criteria.getAttribute("subjectArea"));
      }
      catch (e)
      {
      }
   }

   return tFilter;
}

//-------------------
// xmlElement is the filter element of the criteria to edit.
FilterEditor.prototype.load = function(xmlElement, reportElement)
{
   XUICheckNodeName("FilterEditor.prototype.load", xmlElement, "saw:criteria");
   XUICheckNodeName("FilterEditor.prototype.load", reportElement, "saw:report");

   this.criteria = xmlElement;
   this.report = reportElement;

   //remove expanded and changed saved filters
   this.reduceSavedFilters();

   this.clipboard = null;

   ColumnFilterEditor.initializeOperatorList();
   SubQueryFilterEditor.initializeOperatorList();
   this.displayFilter();

   // expose Requalify option for individual set criteria in list formats
   if (this.bIsListFormat)
   {
      this.listFormatRequalifyTable.style.display = 'none';

      if (XUIGetXsiType(this.criteria) != "derived")
      {
         this.listFormatForm.QualifyingCatalog.value = XUIGetAttributeString (this.criteria, "subjectArea");

         this.listRequalifyCheckErrorTable.style.display = 'none';
         this.listRequalifyCheckErrorCell.innerHTML = "";

         // check if the catalog contains qualified items
         this.listRequalifyCheckCall = new XUIServerCall('idListRequalifyCheck');
         this.listRequalifyCheckCall.execute(this, this.listFormatForm, "MktgCheckRequalifyStatus", "ListCatalogRequalifyCheck");
      }
   }
}

//-------------------
FilterEditor.prototype.apply = function()
{
   // lets not leave that empty node there
   var tFilter = this.getFilterElement();
   if ((tFilter != null) && (!tFilter.hasChildNodes()))
      this.criteria.removeChild(tFilter);

   return true;
}

//-------------------
FilterEditor.prototype.addSubqueryFilterFromFormula = function(sFormula, event)
{
   this.oldExpr = null;

   // Create a temporary filter expr
   this.newExpr = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

   XUISetXsiType(this.newExpr, saw.xml.kSawNamespace, 'subQuery');

   this.newExpr.setAttribute("op", "equal");

   var tFormula = FilterEditor.appendExpr(this.newExpr, saw.xml.kSawxNamespace, "sqlExpression");
   XUISetElementText(tFormula, sFormula);

   // show the ui
   var tSubQueryEditor = new SubQueryFilterEditor('idSubQueryFilter');
   var tDialog = new XUIDialog('idSubQueryFilter', tSubQueryEditor, this);

   if (this.creatingNewFilterCriteria)
      tSubQueryEditor.creatingNewFilterCriteria = this.creatingNewFilterCriteria;
      
   if (this.editingExistingFilterCriteria)
      tSubQueryEditor.editingExistingFilterCriteria = this.editingExistingFilterCriteria;

   // if the event doesn't exist we need to set the position
   if(event != null)
      tDialog.show(this.newExpr, event.clientX, event.clientY, this.criteria);
   else
      tDialog.show(this.newExpr,100,100,this.criteria, null, true, true);
}

//-------------------
// check if the root is a logical expr.  If not, create an and expr and add the
// filter to it.
FilterEditor.prototype.addFilterFromFormula = function(sFormula, event)
{
   this.oldExpr = null;

   // Create a temporary filter expr
   this.newExpr = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

   XUISetXsiType(this.newExpr, saw.xml.kSawxNamespace, 'comparison');

   this.newExpr.setAttribute("op", "equal");
   var tFormula = FilterEditor.appendExpr(this.newExpr, saw.xml.kSawxNamespace, "sqlExpression");
   XUISetElementText(tFormula, sFormula);

   // show the ui
   var bIsMarketingContext = (this.bSegmentCriteriaBlock || this.bSegmentSimpleSelectionRulesEditor);
   var tColumnFilterEditor;
   var tDialog;

   if (!bIsMarketingContext || !XUIDialog.isVisible("idColumnFilter"))
   {
      tColumnFilterEditor = new ColumnFilterEditor('idColumnFilter', null, this.bIsListFormat);
      tDialog = new XUIDialog('idColumnFilter', tColumnFilterEditor, this);


      // if coordinates specified, use them else
      // if the event doesn't exist - or using absolute positioning for segment tree splits -
      // we need to set the position
      //if (iPosLeft && iPosTop)
      // tDialog.show(this.newExpr,iPosLeft,iPosTop,this.criteria);

      if(event != null && (null == this.bSegmentTreeValueSplits))
         tDialog.show(this.newExpr, event.clientX, event.clientY, this.criteria);
      else
         tDialog.show(this.newExpr,100,100,this.criteria, null, true, true);
   }
   else
   {
      var tColumnFilterDiv = XUIPanel.getDiv("idColumnFilter");
      tColumnFilterEditor = tColumnFilterDiv.editor;
      tColumnFilterEditor.load(this.newExpr, this.criteria);
   }

   tColumnFilterEditor.alignValueRowCells();
}

FilterEditor.prototype.addFilterWithBinFromFormula = function(tColumn, event)
{
   this.oldExpr = null;

   var sFormula = XUIGetAttributeString(tColumn, "formula");
   var tBinsElement = tColumn.selectSingleNode("saw:bins").cloneNode(true);

   // Create a temporary filter expr
   this.newExpr = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

   XUISetXsiType(this.newExpr, saw.xml.kSawxNamespace, 'comparison');

   this.newExpr.setAttribute("op", "equal");
   var tFormula = FilterEditor.appendExpr(this.newExpr, saw.xml.kSawxNamespace, "binExpression");
   XUISetAttributeString(tFormula, "formula", sFormula);

   //append bins element
   tFormula.appendChild(tBinsElement);

   // show the ui
   var tColumnFilterEditor = new ColumnFilterEditor('idColumnFilter', null, this.bIsListFormat);
   var tDialog = new XUIDialog('idColumnFilter', tColumnFilterEditor, this);

   // if coordinates specified, use them else
   // if the event doesn't exist - or using absolute positioning for segment tree splits -
   // we need to set the position
   //if (iPosLeft && iPosTop)
   // tDialog.show(this.newExpr,iPosLeft,iPosTop,this.criteria);
   if(event != null && (null == this.bSegmentTreeValueSplits))
      tDialog.show(this.newExpr, event.clientX, event.clientY, this.criteria);
   else
      tDialog.show(this.newExpr,100,100,this.criteria, null, true, true);

   tColumnFilterEditor.alignValueRowCells();
}

//-------------------
FilterEditor.prototype.editColumnFormula = function(tEditor, tExpr)
{
   //last argument is to say that entry is from a filter
   this.columnFormulaEditor = new ColumnFormulaEditor('idFormula', tEditor.bIsListFormat, tExpr);
   var tDialog = new XUIDialog('idFormula', this.columnFormulaEditor, tEditor);

   this.tExprElement = tExpr;

   //create temp expr column
   this.tempFilterColumn = XUICreateElement(saw.xml.kSawNamespace, 'column');
   var sFormula;
   if (XUIGetXsiType(tExpr, "") == "binExpression")
      sFormula = XUIGetAttributeString(tExpr, "formula", "");
   else
      sFormula = XUIGetElementText(tExpr);
   this.tempFilterColumn.setAttribute("formula", sFormula);

   //add bins element
   var tBinsElement = this.tExprElement.selectSingleNode("saw:bins");
   if (null != tBinsElement)
      this.tempFilterColumn.appendChild(tBinsElement.cloneNode(true));

   var nCol = XUIColumnSpace.xmlElement.childNodes.length;
   var sID = XUIGetUniqueColumnID(tEditor.report, nCol);
   this.tempFilterColumn.setAttribute('columnID', sID);

   this.columnsElement = tEditor.criteria.selectSingleNode ("saw:columns");
   if (this.columnsElement == null)
   {
      // happens in segment/segment tree editors
      this.columnsElement = XUICreateElement(saw.xml.kSawNamespace, 'columns');
      tEditor.criteria.appendChild(this.columnsElement);
      this.bRemoveColumnsElement = true;
   }
   this.columnsElement.appendChild(this.tempFilterColumn)
   tDialog.show(this.tempFilterColumn, 20, 80, tEditor.criteria, null, true, true);

}

//-------------------
FilterEditor.prototype.editFilter = function(tExpr, bReEdit, iPosLeft, iPosTop, event)
{
   // Create a temporary filter expr and remember the one being edited unless
   // we are re-editing, in which case leave these alone and show the new dialog
   if (bReEdit != true)
   {
      this.oldExpr = tExpr;
      this.newExpr = tExpr.cloneNode(true);
   }

   // show the ui
   if (XUIGetXsiType(tExpr) == "subQuery")
   {
      var tSQFilterEditor = new SubQueryFilterEditor('idSubQueryFilter');
      var tDialog = new XUIDialog('idSubQueryFilter', tSQFilterEditor, this);

      if (this.creatingNewFilterCriteria)
         tSQFilterEditor.creatingNewFilterCriteria = this.creatingNewFilterCriteria;
         
      if (this.editingExistingFilterCriteria)
         tSQFilterEditor.editingExistingFilterCriteria = this.editingExistingFilterCriteria;

      if (null != iPosLeft && null != iPosTop)
         tDialog.show(this.newExpr, iPosLeft, iPosTop, this.criteria, (bReEdit == true) ? this.htmlTable : null);
      else
         tDialog.show(this.newExpr, 20, event ? event.clientY : 20, this.criteria, (bReEdit == true) ? this.htmlTable : null, true, true);
   }
   else if (XUIGetXsiType(tExpr) == "sql")
   {
      var tSqlFilterEditor = new SqlFilterEditor('idSqlFilter');
      tSqlFilterEditor.creatingNewFilterCriteria = this.creatingNewFilterCriteria;

      if (this.creatingNewFilterCriteria)
         tSqlFilterEditor.creatingNewFilterCriteria = this.creatingNewFilterCriteria;
         
      if (this.editingExistingFilterCriteria)
         tSqlFilterEditor.editingExistingFilterCriteria = this.editingExistingFilterCriteria;

      var tDialog = new XUIDialog('idSqlFilter', tSqlFilterEditor, this);
      if (null != iPosLeft && null != iPosTop)
         tDialog.show(this.newExpr, iPosLeft, iPosTop, this.criteria, (bReEdit == true) ? this.htmlTable : null);
      else
         tDialog.show(this.newExpr, 20, event ? event.clientY : 20, this.criteria, (bReEdit == true) ? this.htmlTable : null, true, true);
   }
   else
   {
      var tColumnFilterEditor = new ColumnFilterEditor('idColumnFilter', null, this.bIsListFormat);
      var tDialog = new XUIDialog('idColumnFilter', tColumnFilterEditor, this);

      tColumnFilterEditor.originalExpr = this.oldExpr;

      if (null != iPosLeft && null != iPosTop)
         tDialog.show(this.newExpr, iPosLeft, iPosTop, this.criteria);
      else if (event != null && null == this.bSegmentTreeValueSplits)
         tDialog.show(this.newExpr, event.clientX, event.clientY, this.criteria);
      else
         tDialog.show(this.newExpr, 20, 100, this.criteria, null, true, true);

      tColumnFilterEditor.alignValueRowCells();
   }
}

//-------------------
FilterEditor.prototype.deleteAllFilters = function()
{
   var tFilter = this.getFilterElement();
   if (tFilter != null)
      this.criteria.removeChild(tFilter);

   // uncheck the list requalify flag if checked
   if (null != this.listFormatForm &&
       null != this.listFormatForm.listRequalify &&
       this.listFormatForm.listRequalify.checked)
   {
      this.listFormatForm.listRequalify.checked = false;
      this.clickListRequalify (false);
   }

   this.clearSegmentCriteriaCounts();
   this.displayFilter();
}

//-------------------
FilterEditor.prototype.deleteFilter = function(tExpr)
{
   var tParent = tExpr.parentNode;
   tParent.removeChild(tExpr);

   this.reduceFilter(this.getFilterElement());
   this.clearSegmentCriteriaCounts();
   this.displayFilter();
}

//-------------------
FilterEditor.prototype.cutFilter = function(tExpr)
{
   var bIsPredicate = XUIGetXsiType (tExpr) == "sql" &&
                      XUIGetElementText (tExpr) == "@{segment.segmentPredicate}{0=1}";

   var tParent = tExpr.parentNode;
   this.clipboard = tParent.removeChild(tExpr);

   this.reduceFilter(this.getFilterElement());

   // uncheck the list requalify flag if the segment predicate is being cut
   if (bIsPredicate &&
       null != this.listFormatForm &&
       null != this.listFormatForm.listRequalify &&
       this.listFormatForm.listRequalify.checked)
   {
      this.listFormatForm.listRequalify.checked = false;
      this.clickListRequalify (false);
   }

   this.clearSegmentCriteriaCounts();
   this.displayFilter();
}

//-------------------
FilterEditor.prototype.copyFilter = function(tExpr)
{
   this.clipboard = tExpr.cloneNode(true);
}

//-------------------
FilterEditor.prototype.pasteFilter = function(tExpr)
{
   if (this.clipboard != null)
   {
      var tParent = tExpr.parentNode;
      if (XUIGetXsiType(tExpr) == "logical")
      {
         tExpr.appendChild(this.clipboard);
      }
      else if (tParent.nodeName == "saw:filter") // add a logical op
      {
         var tLogical = XUICreateElement(saw.xml.kSawxNamespace, 'expr');
         XUISetXsiType(tLogical, saw.xml.kSawxNamespace, 'logical');

         tLogical.setAttribute("op", "and");

         tLogical.appendChild(tParent.removeChild(tExpr));
         tLogical.appendChild(this.clipboard);

         tParent.appendChild(tLogical);
      }
      else // parentNode == "logical"
      {
         if (tExpr.nextSibling != null)
            tParent.insertBefore(this.clipboard, tExpr.nextSibling);
         else
            tParent.appendChild(this.clipboard);
      }

      // make another copy for pasting
      this.clipboard = this.clipboard.cloneNode(true);

      this.clearSegmentCriteriaCounts();
      this.displayFilter();
   }
}

//-------------------
// this function returns true if the logicals match operators
FilterEditor.compareLogicals = function(tLHS, tRHS)
{
   if ((XUIGetXsiType(tLHS) == "logical") && (XUIGetXsiType(tRHS) == "logical"))
   {
      if (tLHS.getAttribute("op") == tRHS.getAttribute("op"))
         return true;
   }

   return false;
}

//-------------------
// move my children into my parent
FilterEditor.prototype.collapseFilter = function(tExpr)
{
   var tParent = tExpr.parentNode;
   if (XUIGetXsiType(tParent) == "logical")
   {
      var tChild = saw.getFirstChildElement(tExpr);
      while (tChild != null)
      {
         var tNext = saw.getNextSiblingElement(tChild);
         tParent.insertBefore(tExpr.removeChild(tChild), tExpr);
         tChild = tNext;
      }

      // Remove the matching logical
      tParent.removeChild(tExpr);

      this.clearSegmentCriteriaCounts();
      this.displayFilter();
   }
}

//-------------------
// Reduce filter by combining and removing logical nodes where possible.  This
// will return the expr to replace tExpr or 0 to delete or null to do nothing
// which avoids issues deleting while iterating
FilterEditor.prototype.reduceFilter = function(tExpr)
{
   // I only care about logical Exprs
   if ((tExpr.nodeName == "saw:filter") || (XUIGetXsiType(tExpr) == "logical"))
   {
      // First, reduce my children
      var tChild = saw.getFirstChildElement(tExpr);
      while (tChild != null)
      {
         var tNext = saw.getNextSiblingElement(tChild);
         var tAction = this.reduceFilter(tChild);

         if (typeof(tAction) == "object") // replace
         {
            if (tAction != null) // tAction is the new child
            {
               tExpr.replaceChild(tAction, tChild);
            }
         }

         else if (tAction == "delete") // delete
         {
            tExpr.removeChild(tChild);
            // no impact on sLogical
         }

         tChild = tNext;
      }

      // For logical expressions, do some other checks
      if (tExpr.nodeName != "saw:filter")
      {
         // If I no longer have children, I have no reason for being
         if (!tExpr.hasChildNodes())
         {
            return "delete"; // indicates deletion
         }

         // If I only have one child, I still have no reason for being
         else if (tExpr.childNodes.length == 1)
         {
            return saw.getFirstChildElement(tExpr);
         }
      }
   }

   return null;
}

//-------------------
// Need to change the op of the selected item.  If it matches a sibling that is
// a logical op, I join that sibling, otherwise I indent to a new logical op

FilterEditor.prototype.changeLogicalOp = function(tExpr)
{
   var tParent = tExpr.parentNode;
   var tSib = saw.getPreviousSiblingElement(tExpr); // not null since we click on the op
   //  tExpr is the one clicked on
   var tNext = saw.getNextSiblingElement(tExpr);

   sNewOp = (tParent.getAttribute("op") == "or") ? "and" : "or";

   // If my parent has only two nodes, just change the op
   if (saw.getChildElementsLength(tParent) <= 2)
   {
      tParent.setAttribute("op", sNewOp);
   }

   else // I no longer match my parent, so indent me and my sibling in a new logical op
   {
      var tIndent = XUICreateElement(saw.xml.kSawxNamespace, 'expr');
      XUISetXsiType(tIndent, saw.xml.kSawxNamespace, 'logical');
      tIndent.setAttribute("op", sNewOp);

      tIndent.appendChild(tSib.cloneNode(true));
      tIndent.appendChild(tParent.removeChild(tExpr));

      tParent.replaceChild(tIndent, tSib);
   }

   this.reduceFilter(this.getFilterElement());
   this.clearSegmentCriteriaCounts();
   this.displayFilter();
}

//-------------------
FilterEditor.prototype.reinitializeFilterPanel = function()
{
   // reinitialize the filter panel in the parent editor
   if (null != this.parentEditor.reinitializeFilterPanel)
      this.parentEditor.reinitializeFilterPanel();
}

//-------------------
FilterEditor.prototype.discard = function()
{
   // if canceling creation of a new filter or editing an existing filter
   // clean up in the parent
   if (this.creatingNewFilterCriteria || this.editingExistingFilterCriteria)
   {
      var tFilter = this.getFilterElement();
      if (tFilter == null || !tFilter.hasChildNodes() || this.editingExistingFilterCriteria)
      {
         this.parentEditor.discard ();
      }
   }

   if (null != this.columnsElement)
   {
      var tColInfo = XUIColumnSpace.findInfo(this.tempFilterColumn.getAttribute("columnID"));
      XUISetOrRemoveAttributeString (tColInfo, "columnID", null);
      this.columnsElement.removeChild(this.tempFilterColumn);
      if (this.bRemoveColumnsElement == true)
      {
         var tColumnsParent = this.columnsElement.parentNode;
         tColumnsParent.removeChild(this.columnsElement);
      }
      this.columnsElement = null;
      this.tempFilterColumn = null;
      this.bRemoveColumnsElement = null;
   }

   if (null != this.columnFormulaEditor)
   {
      this.reinitializeFilterPanel();
      this.columnFormulaEditor = null;
   }
}

//-------------------
// if the columnFilterEditor was creating a new element, add it now
FilterEditor.prototype.onChildApply = function(sourceEditor)
{
   if (this.bIsListFormat)
   {
      if (sourceEditor == this.requalifyConfirmDlg)
      {
         // check the requalify flag for the current criterion
         // after removing it for the previously checked one
         {
            var tCriteria = this.requalifyConfirmDlg.requalifiedCriteria;
            var tFilter = tCriteria.selectSingleNode ("saw:filter");
            var tExpressions = tFilter.selectNodes (".//sawx:expr[@xsi:type='sawx:sql'][.='@{segment.segmentPredicate}{0=1}']");
            var tExpr = tExpressions[0];

            var tParent = tExpr.parentNode;
            tParent.removeChild (tExpr);

            this.reduceFilter (tFilter);

            // remove the segment-specific template attributes in the criteria
            if (XUIGetAttributeString (tCriteria, "templateForEach", "") == "segments")
               XUISetOrRemoveAttributeString (tCriteria, "templateForEach");

            if (XUIGetAttributeString (tCriteria, "templateIterator", "") == "segment")
               XUISetOrRemoveAttributeString (tCriteria, "templateIterator");

            if (XUIGetAttributeString (tCriteria, "templateSetOp", "") == "union")
               XUISetOrRemoveAttributeString (tCriteria, "templateSetOp");
         }

         this.listFormatForm.listRequalify.checked = true;
         this.clickListRequalify (true);

         return;
      }
   }

   var bNeedToRedraw = true;
   if (this.newExpr == sourceEditor.element && sourceEditor.element != null) // make sure we were editing the one we thought
   {
      if (this.oldExpr != null) // editing
      {
         this.oldExpr.parentNode.replaceChild(this.newExpr, this.oldExpr);

         if (this.editingExistingFilterCriteria)
         {
            this.editingExistingFilterCriteria = null;

            // if the parent editor has a call back setup when a column filter change is applied
            if (this.parentEditor && this.parentEditor.applyEditFilterCallBack)
               this.parentEditor.applyEditFilterCallBack();
         }
      }
      else // creating
      {
         var tFilter = this.getFilterElement(true);
         if (!tFilter.hasChildNodes())
         {
            tFilter.appendChild(this.newExpr);
         }

         else if (XUIGetXsiType(saw.getFirstChildElement(tFilter)) == "logical")
         {
            saw.getFirstChildElement(tFilter).appendChild(this.newExpr);
         }

         else // create a logical and and add this expr
         {
            var tCurrent = saw.getFirstChildElement(tFilter);
            tFilter.removeChild(tCurrent);
            var tAnd = FilterEditor.appendExpr(tFilter, saw.xml.kSawxNamespace, "logical", "and");
            tAnd.appendChild(tCurrent);

            tAnd.appendChild(this.newExpr);
         }

         // reset the flag since a predicate was added
         if (this.creatingNewFilterCriteria)
         {
            this.displayFilter();
            bNeedToRedraw = false;

            this.creatingNewFilterCriteria = null;

            if (this.parentEditor &&
                this.parentEditor.applyNewFilterCallBack)
               this.parentEditor.applyNewFilterCallBack();
         }
      }
   }

   if (null != this.columnsElement)
   {
      var tColInfo = XUIColumnSpace.findInfo(this.tempFilterColumn.getAttribute("columnID"));
      if (tColInfo != null)
         XUISetOrRemoveAttributeString (tColInfo, "columnID", null);
      this.columnsElement.removeChild(this.tempFilterColumn);
      if (this.bRemoveColumnsElement == true)
      {
         var tColumnsParent = this.columnsElement.parentNode;
         tColumnsParent.removeChild(this.columnsElement);
      }

      var sNewFormula = XUIGetAttributeString(this.tempFilterColumn, "formula");
      //copy back changes for binning
      //remove old bin element
      var oldBinsElement = this.tExprElement.selectSingleNode("saw:bins");
      if (null != oldBinsElement)
         this.tExprElement.removeChild(oldBinsElement);

      //set the new bins element if it exists
      var newBinsElement = this.tempFilterColumn.selectSingleNode("saw:bins");
      if (null != newBinsElement)
      {
         //if old element had no bins - need to change xsi type and remove inner text
         if (XUIGetXsiType(this.tExprElement) != "binExpression")
         {
            XUISetXsiType(this.tExprElement, saw.xml.kSawxNamespace, 'binExpression');
            XUISetElementText(this.tExprElement, null);
         }
         this.tExprElement.appendChild(newBinsElement.cloneNode(true));
         XUISetAttributeString(this.tExprElement, "formula", sNewFormula);
      }
      else
      {
         //means new column formula is not bin'ed

         //old one was not bin'ed either
         if (null == oldBinsElement)
            XUISetElementText(this.tExprElement, sNewFormula);
         else
         {
            //old was bin'ed but new expr is not
            XUISetXsiType(this.tExprElement, saw.xml.kSawxNamespace, 'sqlExpression');
            XUISetOrRemoveAttributeString(this.tExprElement, "formula", null);
            XUISetElementText(this.tExprElement, sNewFormula);
         }
      }

      this.columnsElement = null;
      this.tempFilterColumn = null;
      this.bRemoveColumnsElement = null;
   }

   this.clearSegmentCriteriaCounts();
   if (bNeedToRedraw)
      this.displayFilter();
   this.oldExpr = null;
   this.newExpr = null;

   if (sourceEditor == this.columnFormulaEditor)
   {
      this.reinitializeFilterPanel();
      this.columnFormulaEditor = null;
   }

}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

//-------------------
FilterEditor.prototype.clearHTMLTable = function()
{
   while (this.htmlTable.rows.length > 0)
      this.htmlTable.deleteRow(0);
}


//-------------------
FilterEditor.showItemMenu = function(event)
{
   NQWPopupMenu(event, 'idFilterItemMenu');
   return false;
}

//-------------------
FilterEditor.prototype.InsertEmptyNotice = function() 
{
   var t = document.getElementById("idNoFiltersDiv");
   if (t)
      t.style.display = "";	
 }

//-------------------
FilterEditor.prototype.RemoveEmptyNotice = function() 
{
   var t = document.getElementById("idNoFiltersDiv");
   if (t)
      t.style.display = "none";	 
}

//-------------------
FilterEditor.addCellsForExpr = function(tExpr, tRow, bInteract)
{
   // Used by UI for determining which expr to edit
   var tCell = tRow.insertCell(tRow.cells.length);
   tCell.className = "FilterEditCell";
   // tCell.noWrap = true; // causing bin ui to go wide
   tCell.expr = tExpr;

   var bLinks = bInteract;
   var bPromptEnforced = "false";     

   var sType = XUIGetXsiType(tExpr);
   switch (sType)
   {
      case "list":
         FilterEditor.getCellForList(tExpr, tCell);
         break;
      case "comparison":
         FilterEditor.getCellForComparison(tExpr, tCell);
         break;
      case "rank":
         FilterEditor.getCellForRank(tExpr, tCell);
         break;
      case "logical":
         FilterEditor.getCellForLogical(tExpr, tCell, bInteract);
         bLinks = false;
         break;
      case "subQuery":
         FilterEditor.getCellForSubQuery(tExpr, tCell);
         break;
      case "special":
         FilterEditor.getCellForSpecial(tExpr, tCell);
         if (tExpr.getAttribute("enforced") != null && tExpr.getAttribute("enforced") == "true")
            bPromptEnforced = "true";
         break;
      case "sql":
         FilterEditor.getCellForSql(tExpr, tCell);
         break;
      default:
         tCell.innerHTML = FilterEditor.getHtmlForExpr(tExpr, tCell);
         if (null != sFilterCaption)
            sFilterCaption += saw.getInnerText(tCell);
         break
   }
   
   

   var bDisableEdits = false;
   var bCounts = false;
   var tEditor = XUIPanel.getEditor ("idFilter");
   if (null != tEditor)
   {
      // should segment filter edits be disabled? If so, don't add edit/delete links
      if (null != tEditor.disableFilterEdits && tEditor.disableFilterEdits == true)
         bDisableEdits = true;

      // should segment filter counts be displayed?
      if (null != tEditor.displayFilterCounts && tEditor.displayFilterCounts == true)
         bCounts = true;
   }

   if (bLinks && !bDisableEdits)
   {
      var tc3 = tRow.insertCell(tRow.cells.length);
      tc3.className = "FilterEditLinks";
      tc3.noWrap = true;

      var ta1 = document.createElement('a');
      ta1.href = "javascript:void(null)";
      saw.addEventListener(ta1, 'click', function(event) { NQWPopupMenu(event, 'idFilterItemMenu'); return false; });
      ta1.expr = tExpr;
      var ti1 = document.createElement('img');
      ti1.setAttribute("border","0");
      ti1.setAttribute("src", kimgFilterEditorMenuIcon);
      ti1.title = kmsgFilterSysFilterOptions;
      ti1.expr = tExpr;
      ta1.appendChild(ti1);

      //if(sType != "savedFilter")
       if (bPromptEnforced == "false")
          tc3.appendChild(ta1);

      var ta2 = document.createElement('a');
      ta2.href = "javascript:void(null)";
      saw.addEventListener(ta2, 'click', function(event) { FilterEditor.onDelete(event); return false; });
      ta2.expr = tExpr;
      var ti2 = document.createElement('img');
      ti2.setAttribute("border","0");
      ti2.setAttribute("src", kimgFilterEditorDelete);
      ti2.title = kmsgFilterSysDelete;
      ti2.expr = tExpr;
      ta2.appendChild(ti2);

      if (bPromptEnforced == "false")
         tc3.appendChild(ta2);
   }
   else if (bCounts)
   {
      // insert a cell anyway to align counts properly
      var tc3 = tRow.insertCell(tRow.cells.length);
      tc3.className = "FilterEditLinks";
   }

   // display filter counts for segments
   if (bCounts)
   {
      // verify if this table has a parent table that's the main filter table itself
      var tTable = GetContainerElement (tRow, false, "TABLE", true);
      if (null != tTable &&
          GetContainerElement (saw.getParentElement(tTable), false, "TABLE", true) == tEditor.htmlTable)
      {
         var tBlankCell = tRow.insertCell (tRow.cells.length);
         // spacing with a hidden span
         {
            var tSeparatorSpan = document.createElement ("span");
            tSeparatorSpan.id = "idBlankSpan";
            tSeparatorSpan.setAttribute("name", "idBlankSpan");
            tSeparatorSpan.style.visibility = "hidden";

            tBlankCell.appendChild (tSeparatorSpan);
            tSeparatorSpan.style.width = 0;
            tBlankCell.noWrap = true;
         }

         // table row at the top level; display count
         var sCount = XUIGetAttributeString (tExpr, "miniCount", "-");
         var tMsg = document.createTextNode (sCount);

         var tCountCell = tRow.insertCell (tRow.cells.length);
         tCountCell.className = "SegmentFilterTableCell";

         var tSpanNode = document.createElement ("span");
         tSpanNode.className = "SegmentFilterTableCellSpan";
         tSpanNode.appendChild (tMsg);

         tCountCell.appendChild (tSpanNode);

         // last mini-count updated tooltip
         var sTimeStamp = XUIGetAttributeString (tExpr, "lastMiniCountUpdatedDateTime", "");
         if (sTimeStamp != "")
         {
            var tDTP = new DateTimeParser ();
            var tDate = DateTimeParser.parseXmlDateTime (sTimeStamp);
            var sDisplayDateTime = "";

            if (tDate != null)
            {
               //tDate.adjustUTCToLocalTimezone ();
               tDate.adjustTimeZoneOffset(saw.tz.getGeneralDisplayTZOffset());
               sDisplayDateTime = tDTP.formInputString (tDate);
            }

            if (sDisplayDateTime != "")
               tSpanNode.title = kmsgMktgTooltipCountLastUpdated + sDisplayDateTime;
         }
         else
            tSpanNode.title = kmsgMktgTooltipNoCountAvailable;
      }
   }
}

//-------------------
FilterEditor.getHtmlForExpr = function(tExpr, tCell)
{
   var sType = XUIGetXsiType(tExpr);
   switch (sType)
   {
      case "sqlExpression":
         return FilterEditor.getHtmlForSql(tExpr);
         break;
      case "decimal":
      case "double":
      case "float":
         return FilterEditor.getHtmlForNumber(tExpr);
      case "string":
      case "untypedLiteral":
         return FilterEditor.getHtmlForUntypedLiteral(tExpr);
         break;
      case "date":
      case "time":
      case "dateTime":
         return FilterEditor.getHtmlForDateTimeLiteral(tExpr);
      case "variable":
         return FilterEditor.getHtmlForVariable(tExpr);
         break;
      case "eval":
         return FilterEditor.getHtmlForWebVariable(tExpr);
         break;
      case "special":
         return FilterEditor.getHtmlForSpecial(tExpr);
         break;
      case "savedFilter":
         return FilterEditor.getHtmlForSavedFilter(tExpr, tCell);
         break;
      case "binExpression":
         return FilterEditor.getHtmlForBinExpr(tExpr);
         break;
      default:
         return tExpr.nodeName + tExpr.getAttribute("xsi:type") + tExpr.getAttribute("op");
         break
   }
}

//-------------------
FilterEditor.getCellForSpecial = function(tExpr, tCell)
{
   var tProps = ColumnFilterEditor.opArray[tExpr.getAttribute("op")];
   var sHtml = FilterEditor.getHtmlForExpr(saw.getFirstChildElement(tExpr));
   sHtml += ' ' + tProps.display;

   tCell.innerHTML = sHtml;
   if (null != sFilterCaption)
      sFilterCaption += saw.getInnerText(tCell);
}

//-------------------
FilterEditor.getCellForSql = function(tExpr, tCell)
{
   var sSQL = XUIGetElementText(tExpr);

   if (sSQL == "@{segment.segmentPredicate}{0=1}")
   {
      sSQL = kmsgMktgEFRequalifyFilterPredicate;
   }

   tCell.innerHTML = sSQL;
   tCell.dir = "ltr";
   if (null != sFilterCaption)
      sFilterCaption += saw.getInnerText(tCell);
}

//-------------------
FilterEditor.getHtmlForBinExpr = function(tExpr)
{
   var sSQL = XUIGetAttributeString(tExpr, "formula", "");
   return FilterEditor.getHtmlForSql (tExpr, sSQL);
}

//-------------------
FilterEditor.getHtmlForSql = function(tExpr, sSQL)
{
   if (null == sSQL)
      sSQL = XUIGetElementText(tExpr);

   var tInfo = XUIColumnSpace.findInfo(null, sSQL);
   if (tInfo)
   {
      var sSQLTemp = XUIColumnSpace.getInfoHeading(tInfo, "saw:columnHeading");
      if (sSQLTemp != "")
         return sSQLTemp;

      var sqlInfo = tInfo.selectSingleNode("saw:SQLInfo");
      if(sqlInfo)
      {
         var sDisplayFormula = XUIGetAttributeString(sqlInfo, "displayFormula");
         if(sDisplayFormula != "")
         {
            var display = XUIColumn.getDisplayHeadingFromFormula(sDisplayFormula);
            if(display != "")
               return display;
         }
      }
   }

   return XUIColumn.getDisplayHeadingFromFormula(sSQL);
}

//-------------------
FilterEditor.getHtmlForUntypedLiteral = function(tExpr)
{
   return "<span class='FilterEditValueSpan'>" + saw.encodeHTML(XUIGetElementText(tExpr)) + "</span>";
}

FilterEditor.getHtmlForNumber = function(tExpr)
{
   return "<span class='FilterEditValueSpan'>" + XUIGetElementText(tExpr).replace('.',g_LocaleInfo.sDecimalPoint) + "</span>";
}


//-------------------

FilterEditor.getHtmlForDateTimeLiteral = function(tExpr)
{
   var t = SAWDateTime.convertFromXml(tExpr);
   
   t.adjustTimeZoneOffset(FilterEditor.getDataToDisplayTZOffset(tExpr));

   if(t  != null)
   {
      return "<span class='FilterEditValueSpan'>" + tDTP.formInputString(t ) +
      "</span>";
  }

  return tExpr.xml;
}

//-------------------
FilterEditor.getHtmlForVariable = function(tExpr)
{
   return XUIGetElementText(tExpr);
}

//-------------------
FilterEditor.getHtmlForWebVariable = function(tExpr)
{
   var sHtml = "<span class='FilterEditWebVariableSpan'>" + "@{" + XUIGetElementText(tExpr) + "}";
   
   var sDefault = tExpr.getAttribute("default");
   
   if(sDefault != null)
      sHtml += "{" + sDefault + "}";
     
   sHtml += "</span>";
   return sHtml;
}

//-------------------
FilterEditor.getCellForLogical = function(tExpr, tCell, bInteract)
{
   var sOp = XUIGetAttributeString(tExpr, "op", "and");
   var tt = document.createElement('table');
   tt.className = "FilterEditTable";
   tCell.appendChild(tt);

   var tEditor = XUIPanel.getEditor('idFilter');

   var sOpMsg = (sOp == "or") ? kmsgFilterDisplayEditableOR : kmsgFilterDisplayEditableAND;

   if (null != sFilterCaption)
      sFilterCaption += "(";

   var t = saw.getFirstChildElement(tExpr);
   while (t != null)
   {
      var tr = tt.insertRow(tt.rows.length);
      var tc1 = tr.insertCell(tr.cells.length);
      tc1.className = "FilterEditOpCell";
      tc1.style.position = "static";
      if (t != saw.getFirstChildElement(tExpr))
      {
         var tMsg = document.createTextNode(sOpMsg);

         if (bInteract && !(null != tEditor && null != tEditor.disableFilterEdits && tEditor.disableFilterEdits == true))
         {
            var tLink = document.createElement('a');
            tLink.setAttribute("href", "javascript:void(null)");
            tLink.onclick = function (event) { eval("FilterEditor.onLogicalOp(saw.getEvent(event));") };
            tLink.appendChild(tMsg);
            tLink.expr = t;

            tc1.appendChild(tLink);
         }
         else
            tc1.appendChild(tMsg);

         if (null != sFilterCaption)
            sFilterCaption += " " + sOpMsg + " ";
      }

      FilterEditor.addCellsForExpr(t, tr, bInteract);

      t = saw.getNextSiblingElement(t);
   }

   if (null != sFilterCaption)
      sFilterCaption += ")";

   // if disabling segment filter edits, do not allow changes via the group menu
   if (null != tEditor && null != tEditor.disableFilterEdits && tEditor.disableFilterEdits == true)
      return;

   // Filter group options
   if (tExpr.parentNode.nodeName != "saw:filter")
   {
      var tRX = tt.insertRow(tt.rows.length);
      var tCX = tRX.insertCell(tRX.cells.length);
      tCX.className = "FilterEditGroupOptionsCell";
      tCX.colSpan = "3";

      var tSX = document.createElement('span');
      tSX.className = "minibuttonOn";

      var tLX = document.createElement('a');
      tLX.href = "javascript:void(null)";
      tLX.onclick = function(event) { NQWPopupMenu(saw.getEvent(event), 'idFilterGroupMenu'); return false; };
      tLX.expr = tExpr;

      tLX.appendChild(document.createTextNode(kmsgFilterEditorEditFilterGroup));

      // Change to button

      //var tMsg = document.createElement("img");
      //tMsg.border = "0";
      //tMsg.src = kimgFilterEditorMenuEllipses;
      //tMsg.expr = tExpr;
      //tLX.appendChild(tMsg);


      tSX.appendChild(tLX);
      tCX.appendChild(tSX);
   }
}

//-------------------
FilterEditor.getCellForComparison = function(tExpr, tCell)
{
   var sOp = tExpr.getAttribute("op");
   if (sOp == "equal")
      sOp = "in";

   var tExprFirstChild = saw.getFirstChildElement(tExpr);
   var tProps = ColumnFilterEditor.opArray[sOp];
   var sHtml = FilterEditor.getHtmlForExpr(tExprFirstChild);

   if ((sOp == "null") || (sOp == "notNull"))
   {
      sHtml += ' ' + tProps.display;
   }
   else
   {
      if (tProps != undefined)
         sHtml += ' ' + tProps.display + ' ';
      else
         sHtml += ' <font color="red">[unknown operator <b>' + sOp + '</b>]</font> ';

      if (saw.getNextSiblingElement(tExprFirstChild) == null)
         sHtml += " [missing value] ";
      else
         sHtml += FilterEditor.getHtmlForExpr(saw.getNextSiblingElement(tExprFirstChild));

      if(sOp == "between")
      {
         sHtml += ' ' + kmsgFCCBetweenDatesSeparator + ' ';
         if (tExpr.lastChild == null)
            sHtml += " [missing value] ";
         else
            sHtml += FilterEditor.getHtmlForExpr(saw.getLastChildElement(tExpr));
      }
   }

   tCell.innerHTML = sHtml;
   tCell.dir = "ltr";
   if (null != sFilterCaption)
      sFilterCaption += saw.getInnerText(tCell);
}

//-------------------
FilterEditor.getCellForRank = function(tExpr, tCell)
{   
   var tProps = ColumnFilterEditor.opArray[tExpr.getAttribute("op")];
   var tExprFirstChild = saw.getFirstChildElement(tExpr);
   var sHtml = FilterEditor.getHtmlForExpr(tExprFirstChild);
   sHtml += ' ' + tProps.display + ' ';
   if (saw.getNextSiblingElement(tExprFirstChild) == null)
      sHtml += " [missing value] ";
   else
   {
      sHtml += FilterEditor.getHtmlForExpr(saw.getNextSiblingElement(tExprFirstChild));
   }

   tCell.innerHTML = sHtml;
   if (null != sFilterCaption)
      sFilterCaption += saw.getInnerText(tCell);
}

//-------------------
FilterEditor.getCellForSubQuery = function(tExpr, tCell)
{
   var tProps = SubQueryFilterEditor.opArray[tExpr.getAttribute("op")];
   var tExprFirstChild = saw.getFirstChildElement(tExpr);
   var sHtml = FilterEditor.getHtmlForExpr(tExprFirstChild);
   sHtml += ' ' + tProps.display + ' ';
   if (saw.getNextSiblingElement(tExprFirstChild) == null)
      sHtml += " [missing value] ";
   else
      sHtml += FilterEditor.getHtmlForColumnRef(saw.getNextSiblingElement(tExprFirstChild));

   tCell.innerHTML = sHtml;
   if (null != sFilterCaption)
      sFilterCaption += saw.getInnerText(tCell);
}

//-------------------
FilterEditor.getCellForList = function(tExpr, tCell)
{
   var tProps = ColumnFilterEditor.opArray[tExpr.getAttribute("op")];
   var tExprFirstChild = saw.getFirstChildElement(tExpr);
   var sHtml = FilterEditor.getHtmlForExpr(saw.getFirstChildElement(tExpr));
   sHtml += ' ' + tProps.display + ' ';

   var first = saw.getNextSiblingElement(tExprFirstChild);
   var t = first;
   while (t != null)
   {
      if (t.nodeType == 1)
      {
         if (t != first)
            sHtml += ', ';

         sHtml += FilterEditor.getHtmlForExpr(t);
      }
      t = t.nextSibling;
   }

   tCell.innerHTML = sHtml;
   if (null != sFilterCaption)
      sFilterCaption += saw.getInnerText(tCell);
}

//-------------------
FilterEditor.getHtmlForSavedFilter = function(tExpr, tCell)
{
   var tExpandedExpr = tExpr.selectSingleNode("saw:filter/sawx:expr");
   if (XUIGetAttributeString(tExpr,"changed") == "true" && tExpandedExpr)
   {
      var tr = tCell.parentNode;
      tr.removeChild(tCell);
      return FilterEditor.addCellsForExpr(tExpandedExpr, tr, false);
   }
   else
   {

      var sName;
      //if (typeof(SavedFiltersCaptions) != undefined)
      //   sName = SavedFiltersCaptions[XUIGetAttributeString(tExpr,"path").replace("\\/","/")];
      sName = XUICatalogCaptionSpace.getLocalizedCaption(XUIGetAttributeString(tExpr,"path"));
      if(sName == undefined)
      {
         sName = XUIGetAttributeString(tExpr,"name");
         if(sName == "")
         {
            sName = "(unable to determine name)";
         }
      }

      var sHtml = "<img border=0 align='absmiddle' src='" + kimgFilterEditorSaved + "'> ";
      sHtml += "<span style='font-weight:bold'>" + sName + "</span>";

      return sHtml;
   }
}

//-------------------
FilterEditor.getHtmlForColumnRef = function(tExpr)
{
   var sPath = XUIGetAttributeString(tExpr, "path");
   var sColID = XUIGetAttributeString(tExpr, "columnID");
   //FilterEditor.getColumnInfoFromServer(sPath, sColID);
   var tRequest = XUICreateElement (saw.xml.kSawNamespace, "request");
   tRequest.setAttribute("path", sPath);
   tRequest.setAttribute("colID", sColID);
   tColumnInfoRequests.appendChild(tRequest);

   // write out text before server calls back
   var sReportName =  XUICatalogCaptionSpace.getLocalizedCaption(sPath);;
   //while (sReportName.indexOf('/') >= 0)
   //   sReportName = sReportName.substr(sReportName.indexOf('/') +1);

   var sHtml = "<span id='" + sPath + "." + sColID + "." + saw.getChildElementsLength(tColumnInfoRequests) + "' style='font-weight:bold; padding-right:1px'></span>";
   sHtml += " in ";
   sHtml += "<span style='font-weight:bold'><img src='" + kimgFilterEditorRequest +"'/> " + sReportName + "</span>";
   return sHtml;
}

//-------------------
FilterEditor.getColumnInfoFromServer = function()
{
   tEditor = XUIPanel.getEditor("idFilter");
   //tEditor.form.Path.value = sPath;
   saw.addHiddenInput(tEditor.form, "ColumnRequests", saw.getXmlText(tColumnInfoRequests));
   
   var req = new sawr.serverRequest("GetReportColumnsXML", FilterEditor.loadColumnXML);
 	req.setFatalErrorHandler(FilterEditor.handleServerError);
   req.setCallerObj(tEditor);
   
   var conn = new sawr.xhrConnection(req);
   conn.postForm(tEditor.form);
   
   return false;
}

FilterEditor.handleServerError = function(tData, aFatal)
{
   if (aFatal && aFatal.length)  
   {
      for (var i=0; i<aFatal.length; i++)
      {
         alert(aFatal[i].getType() + " : " + aFatal[i].getMessage());
      } 
   }
   else
      alert(kmsgFilterEditorSubQueryFilterColumnInfoError);

   tEditor.clearColumnRequest();
}

FilterEditor.loadColumnXML = function(tData)
{
   var tEditor = tData.getCallerObj();
   
   var sHeading;

   tRequest = saw.getFirstChildElement(tColumnInfoRequests);
   var i = 1;
   while (tRequest)
   {
      sPath = tRequest.getAttribute("path");
      sColID = tRequest.getAttribute("colID");
      var tColumn = tData.getXML().selectSingleNode(".//saw:request[@path='" + sPath + "']/saw:columns/saw:column[@columnID='" + sColID + "']");
      if (tColumn)
      {
         var sColID = tColumn.getAttribute("columnID");
         sHeading = XUIColumnSpace.getHeadingFromColumn(tColumn, "saw:columnHeading");
         var tHeading = document.getElementById(sPath + "." + sColID + "." + i);
         if (tHeading)
            tHeading.innerHTML = sHeading;
      }
      tRequest = saw.getNextSiblingElement(tRequest);
      i++;
   }
   tEditor.clearColumnRequest();
}

FilterEditor.prototype.clearColumnRequest = function()
{
   this.form.Path.value = "";
   this.form.ColumnID.value = "";
   tColumnInfoRequests = null;
   this.form.ColumnRequests.value = "";
}


//-------------------
FilterEditor.prototype.serverResponse = function(bOK, result, sCallerContext)
{
   if (this.bIsListFormat && null != sCallerContext && sCallerContext == "ListCatalogRequalifyCheck")
   {
      if (!bOK)
      {
         if (result == null)
            alert (kmsgMktgEFErrorCheckingListCatalogRequalifyStatus);
         else
         {
            // check if a browser back caused the requalify check iframe onload; suppress any error
            var tIFrame = document.getElementById ("idListRequalifyCheckIFrame");
            if (null != tIFrame)
            {
               var tDoc = saw.getContentDocument (tIFrame);
               if (null != tDoc)
               {
                  var tIsland = saw.getXmlIsland("idXUI");
                  if (null == tIsland.documentElement)
                     return;
               }
            }

            this.listRequalifyCheckErrorTable.style.display = '';
            this.listRequalifyCheckErrorCell.innerHTML = result;
         }
      }
      else
      {
         var bCanRequalify = false;
         var tCatalog = result.selectSingleNode (".//saw:listCatalog");
         if (tCatalog)
         {
            var sRequalify = XUIGetAttributeString (tCatalog, "status", "false");
            if (sRequalify == "true")
            {
               this.listFormatRequalifyTable.style.display = '';

               var tFilterElement = this.getFilterElement ();
               // check if the criteria has been templatized already
               // this could be detected by looking at the template attributes for sets in derived criteria
               // or if a simple criteria, presence of the predicate indicates templatization
               var sTemplateForEach = XUIGetAttributeString (this.criteria, "templateForEach", "");
               if (sTemplateForEach == "segments" ||
                   (this.parentEditor.isPrimarilyDerived != null &&
                    !this.parentEditor.isPrimarilyDerived() &&
                    null != tFilterElement &&
                    (tFilterElement.selectNodes (".//sawx:expr[@xsi:type='sawx:sql'][.='@{segment.segmentPredicate}{0=1}']")).length > 0))
               {
                  this.listFormatForm.listRequalify.checked = true;
                  this.clickListRequalify (true);
               }
               else
               {
                  this.listFormatForm.listRequalify.checked = false;
                  this.clickListRequalify (false);
               }
               bCanRequalify = true;
            }
         }
         if (!bCanRequalify)
         {
            this.listFormatRequalifyTable.style.display = 'none';

            this.listFormatForm.listRequalify.checked = false;
            this.clickListRequalify (false);
         }
      }
      return;
   }

}

//-------------------
FilterEditor.prototype.displayFilter = function()
{   
   this.clearHTMLTable();

   tColumnInfoRequests = XUICreateElement(saw.xml.kSawNamespace, "requests");

      sFilterCaption = null;
   // if filter is empty, display a caption for segment elements
   var tSegCaption = document.getElementById (this.prefixID + "BlankCriteriaPrompt");
   // if filter is not empty, display a caption to prompt for additional elements
   var tSegAdditionalCaption = document.getElementById (this.prefixID + "AdditionalCriteriaPrompt");

   // render predicates in read-only mode (currently used when splitting Segment Tree nodes by value)
   var bInteract = (null == this.bSegmentTreeValueSplits || !this.bSegmentTreeValueSplits);

   // if editing an existing split, enable edits on the filter predicates
   if (null != this.bSegmentTreeValueSplitsForEdit && this.bSegmentTreeValueSplitsForEdit)
      bInteract = true;

   var tFilter = this.getFilterElement();
   if ((tFilter != null) && tFilter.hasChildNodes() && tFilter.selectSingleNode("sawx:expr"))
   {
      var tr = this.htmlTable.insertRow(this.htmlTable.rows.length);
      var filterFirstChild = tFilter.selectSingleNode("sawx:expr");
      // If a non-logical filter, then draw a filter table so it looks nice
      //alert(tFilter.childNodes.length);

      if (XUIGetXsiType(filterFirstChild) != "logical")
      {
         var tCell = tr.insertCell(tr.cells.length);
         tCell.className = "FilterEditCell";

         var tt = document.createElement('table');
         tt.className = "FilterEditTable";
         tCell.appendChild(tt);
         tr = tt.insertRow(tt.rows.length);
      }

      if (this.bSegmentCriteriaBlock || this.bSegmentTreeValueSplitsForEdit
            || this.bSegmentSimpleSelectionRulesEditor)
         sFilterCaption = "";

      FilterEditor.addCellsForExpr(filterFirstChild, tr, bInteract);

      this.links.style.display = '';
      if (!bInteract || (null != this.bSegmentTreeValueSplitsForEdit && this.bSegmentTreeValueSplitsForEdit))
         this.links.style.display = 'none';

      if (null != tSegCaption)
         tSegCaption.style.display = 'none';
      if (null != tSegAdditionalCaption)
         tSegAdditionalCaption.style.display = '';
         
		this.RemoveEmptyNotice();
   }
   else
   {
      this.links.style.display = 'none';

      if (null != tSegCaption)
         tSegCaption.style.display = '';
      if (null != tSegAdditionalCaption)
         tSegAdditionalCaption.style.display = 'none';
         
		this.InsertEmptyNotice();
   }

   this.htmlTable.sFilterCaption = null;
   if (null != sFilterCaption &&
       sFilterCaption != "")
   {
      if (this.bSegmentTreeValueSplitsForEdit)
      {
         this.htmlTable.sFilterCaption = sFilterCaption;
      }
      else if (this.bSegmentCriteriaBlock)
      {
         // get the label element and update the text with the complete filter caption
         var tLabelInput = document.getElementById ('idElementLabel');
         if (tLabelInput != null)
            tLabelInput.value = sFilterCaption;
      }
      else if (this.bSegmentSimpleSelectionRulesEditor)
      {
         this.htmlTable.sFilterCaption = sFilterCaption;
      }
   }

   if (null != this.displayFilterCounts && this.displayFilterCounts == true)
   {
      this.links.style.display = 'none';
      this.padFilterCountBlankCells ();
   }

   if (null != this.disableFilterEdits && this.disableFilterEdits == true)
   {
      // if disabling edits, do not display segment filter captions
      if (null != tSegCaption)
         tSegCaption.style.display = 'none';
      if (null != tSegAdditionalCaption)
         tSegAdditionalCaption.style.display = 'none';
   }

   if (tColumnInfoRequests && tColumnInfoRequests.childNodes.length > 0)
      FilterEditor.getColumnInfoFromServer();
}

//-------------------
FilterEditor.prototype.getRequalifiedCriteria = function()
{
   var tReturnCrit = null;

   var tCriteria = this.report.selectNodes (".//saw:criteria");
   if (null != tCriteria && tCriteria.length > 0)
   {
      //var tCrit = tCriteria.nextNode;
      for (var i = 0; i < tCriteria.length; i++)
      {
         var tFilter = tCriteria[i].selectSingleNode ("saw:filter");
         if (null != tFilter)
         {
            var tExpressions = tFilter.selectNodes (".//sawx:expr[@xsi:type='sawx:sql'][.='@{segment.segmentPredicate}{0=1}']");

            if (null != tExpressions && tExpressions.length > 0)
            {
               tReturnCrit = tCriteria[i];
               break;
            }
         }

         //tCrit = tCriteria.nextNode;
      }
   }

   return tReturnCrit;
}

//-------------------
FilterEditor.prototype.padFilterCountBlankCells = function()
{
   // pad the blank cells so that the counts line up with the preceding count
   var tBlankSpans = document.getElementsByName ('idBlankSpan');
   if (null != tBlankSpans)
   {
      var tPrecedingCountTable = document.getElementById ("idFilterPrecedingCountOuterTable");
      var nPadding = saw.calcAbsoluteRight(tPrecedingCountTable) - saw.calcAbsoluteRight(this.htmlTable);
      if (nPadding > 0)
      {
         if (tBlankSpans.length > 0)
         {
            var counter;
            for (counter = 0; counter < tBlankSpans.length; counter++) {
               tBlankSpans[counter].parentElement.style.width =  nPadding +"px";
            }
         }
      }
   }
}

//-------------------
FilterEditor.prototype.clearSegmentCriteriaCounts = function()
{
   var tParentEditor = this.parentEditor;
   if (null != tParentEditor && null != tParentEditor.clearSegmentCriteriaCounts)
      tParentEditor.clearSegmentCriteriaCounts ();
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

//-------------------
FilterEditor.onDelete = function(event)
{
   var tEditor = XUIPanel.getEditor('idFilter');

   // uncheck the list requalify flag if the segment predicate is being deleted
   // deleteFilter will be invoked from clickListRequalify
   if (XUIGetXsiType (saw.getEventTarget(event).expr) == "sql" &&
       XUIGetElementText (saw.getEventTarget(event).expr) == "@{segment.segmentPredicate}{0=1}")
   {
      if (null != tEditor.listFormatForm &&
          null != tEditor.listFormatForm.listRequalify &&
          tEditor.listFormatForm.listRequalify.checked)
      {
         tEditor.listFormatForm.listRequalify.checked = false;
         tEditor.clickListRequalify (false);
         return;
      }
   }

   tEditor.deleteFilter(saw.getEventTarget(event).expr);
}

//-------------------
FilterEditor.onRemoveFilters = function()
{
   var tEditor = XUIPanel.getEditor('idFilter');

   tEditor.deleteAllFilters();

   if (typeof(ReportPageEditor) == "undefined")
   {
      var tNameCell = document.getElementById("idNameCell");
      tNameCell.innerHTML = "";
   }
}

//-------------------
FilterEditor.onLogicalOp = function(event)
{
   var tEditor = XUIPanel.getEditor('idFilter');

   // if disabling segment filter edits, do not allow changes
   if (null != tEditor.disableFilterEdits && tEditor.disableFilterEdits == true)
      return;

   tEditor.changeLogicalOp(saw.getEventTarget(event).expr);
}

//-------------------
FilterEditor.initializeFilterGroupMenu = function(event, tMenu)
{
   var tEditor = XUIPanel.getEditor('idFilter');

   tMenu.expr = saw.getEventTarget(event).expr;

   var tList = tMenu.getElementsByTagName('A');
   for(var i = 0 ; i != tList.length ; ++i)
   {
      if(tList[i].name == 'paste')
      {
         tList[i].style.display = tEditor.clipboard == null ? "none" : "";
         break;
      }
   }
}

//-------------------
FilterEditor.initializeFilterItemMenu = function(event, tMenu)
{
   var tEditor = XUIPanel.getEditor('idFilter');

   tMenu.expr = saw.getEventTarget(event).expr;
   var sType = XUIGetXsiType(tMenu.expr);

   var tList = tMenu.getElementsByTagName('A');
   for(var i = 0 ; i != tList.length ; ++i)
   {
      switch(tList[i].name)
      {
         case 'paste':
         {
            tList[i].style.display = (tEditor.clipboard == null) ? "none" : "";
            break;
         }
         case 'edit':
         {
            tList[i].style.display = (sType == "savedFilter") ? "none" : "";
            break;
         }
         case 'editFormula':
         {
            tList[i].style.display = (tEditor.bAllowEditFormula == false || sType == "savedFilter" || sType == "sql") ? "none" : "";
            tList[i].previousSibling.style.display = (tEditor.bAllowEditFormula == false || sType == "savedFilter" || sType == "sql") ? "none" : "";
            break;
         }
         case 'view':
         {
            tList[i].style.display = (sType == "savedFilter") ? "" : "none";
            break;
         }
         case 'protect': // hide if isPrompted along with the preceding separator
         {
            var bHideMenu = ((sType == "special") || (sType == "savedFilter")) && !XUIGetAttributeBool(tMenu.expr, "protected", false);
            // hide in the Marketing contexts
            bHideMenu = bHideMenu || tEditor.bSegmentCriteriaBlock || tEditor.bIsListFormat
                        || tEditor.bSegmentSimpleSelectionRulesEditor;

            tList[i].style.display = bHideMenu ? "none" : "";
            tList[i].previousSibling.style.display = bHideMenu ? "none" : "";

            // otherwise, check protected attribute
            var bProtect = XUIGetAttributeBool(tMenu.expr, "protected");
            saw.menuCheckmarkItems(tMenu, "name", bProtect ? "protect" : "");

            break;
         }
      }
   }
}

//-------------------
FilterEditor.onMenuCut = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);
   tEditor.cutFilter(saw.activeMenu.expr);

   NQWClearActiveMenu();
}

//-------------------
FilterEditor.onMenuCopy = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);
   tEditor.copyFilter(saw.activeMenu.expr);

   NQWClearActiveMenu();
}

//-------------------
FilterEditor.onMenuPaste = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);
   tEditor.pasteFilter(saw.activeMenu.expr);

   NQWClearActiveMenu();
}

//-------------------
FilterEditor.onMenuCollapse = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);
   tEditor.collapseFilter(saw.activeMenu.expr);

   NQWClearActiveMenu();
}

//-------------------
FilterEditor.onMenuEdit = function(eid, event)
{
   var tEditor = XUIPanel.getEditor(eid);
   tEditor.editFilter(saw.activeMenu.expr, false, null, null, event);

   NQWClearActiveMenu();
}

//-------------------
FilterEditor.onMenuEditColumnFormula = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);
   tEditor.editColumnFormula(tEditor, saw.getFirstChildElement(saw.activeMenu.expr));

   NQWClearActiveMenu();
}

//-------------------
FilterEditor.onMenuView = function(eid, event)
{
   var tEditor = XUIPanel.getEditor(eid);
   var sPath = XUIGetAttributeString(saw.activeMenu.expr, "path");

   var tViewFilterEditor = new ViewFilterEditor('idFilterView', sPath);
// var tDialog = new XUIDialog('idFilterView', ViewFilterEditor, this);
//   tDialog.show(saw.activeMenu.expr, event.clientX, event.clientY, this.criteria);
   tViewFilterEditor.loadSavedFilter(20, event.clientY);

   NQWClearActiveMenu();
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
FilterEditor.onDeleteFilter = function(eid, sDefaultPath)
{
    var tEditor = XUIPanel.getEditor(eid);

   if (tEditor.form.ItemName.value == "") 
   {  // doesn't need to be deleted as it was never saved
      parent.location.href = saw.commandToURL("Answers");
   }   
   var ItemPath = sDefaultPath + "/" + tEditor.form.ItemName.value

   var bgo = confirm(kmsgFilterSysConfirmDeleteFilter)

   if (bgo)
   {
      try
      {
        var hiddenframe = window.frames[eid +"ApplyFrame"];
        if (hiddenframe)
        {
           var tFilter = tEditor.getFilterElement();
           var sFilterXml = tFilter == null ? "" : saw.getXmlText(tFilter);
           var tForm = tEditor.form;

           tForm.ReportXML.value = sFilterXml;
           if (!tForm.OnDeleteDone)
             saw.addHiddenInput(tForm,"OnDeleteDone","");

           tForm.OnDeleteDone.value = "parent.FilterEditor.OnDeleteDone('" + eid + "')";

           tForm.action = saw.commandToURL("DeleteFilter");
           tForm.target = hiddenframe.name;
           tForm.submit();
        }
        else
        {
          alert("no iframe?");
          throw "no iframe";
        }
      }
      catch (x)
      {
         // alert("error in delete filter")
      }
   }
}

/////////////////////////////////////////////////////////////
FilterEditor.OnDeleteDone = function(eid)
{
   try
   {
      var tEditor = XUIPanel.getEditor(eid);

      var hiddenframe = window.frames[eid +"ApplyFrame"];
      if (hiddenframe)
      {
         var tDeleteDoneForm = hiddenframe.document.DeleteDoneForm;

         if (tDeleteDoneForm.Success.value == "true")
         {
         //alert("got rid of the filter" + tDeleteDoneForm.Folder.value  + tDeleteDoneForm.ItemName.value )
         parent.location.href = saw.commandToURL("Answers");
         }
         else
         {
            alert(tDeleteDoneForm.ErrorMsg.value);
            throw "Delete did not succeed";
         }
      }
      else
      {
         alert("no iframe");
         throw "no iframe";
      }
   }
   catch (x)
   {
     // alert("error in delete filter")
   }
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////
FilterEditor.onSaveFilter = function(eid, sDefaultPath)
{
   var tEditor = XUIPanel.getEditor(eid);
   var tFilter = tEditor.getFilterElement();

   if ((tFilter != null) && tFilter.hasChildNodes())
   {
      var RootXML = XUIGetRootXML();
      var elem = RootXML.selectSingleNode('//*[@subjectArea]');

      //create xml def
      var tCBDef = CatalogBrowser.createDefaultDef(eid);
      var bOpenPath = true;
      if(tEditor.form.Folder.value.indexOf("/_filters/_remote") != -1)
      {
         bOpenPath = false;
         tEditor.form.Folder.value="";
      }

      tCBDef.setTarget("Folder", bOpenPath);
      tCBDef.setType("saveBrowser");
      tCBDef.setTitle("kmsgBrowserSaveFilterTitle");
      tCBDef.setTargetCaption("kmsgBrowserItemFolder");
      tCBDef.setCommand("LoadFolderBrowser");
      if (sDefaultPath)
         tCBDef.setDefaultPath(sDefaultPath);

      if (typeof(ReportPageEditor) != "undefined")
      {
         tEditor.form.Folder.value = "";
         tEditor.form.ItemName.value = "";
      }

      tCBDef.setAttribute("newFolderAttributes", "hiddenSystem");
      tCBDef.addParam("subjectArea", XUIGetAttributeString(elem,"subjectArea",""));

      var sSubjectAreaName = CriteriaValidator.removeQuotes(XUIGetAttributeString(elem,"subjectArea",""));
      tCBDef.setPersonalFilters("kmsgFilterFolderPickerTreeDefXml", null, sSubjectAreaName, "filterfolder");
      tCBDef.setSharedFilters("kmsgFilterFolderPickerTreeDefXml", null, sSubjectAreaName, "filterfolder");

      CatalogBrowser.openBrowser(eid, saw.hooks.CustomizeCBDef(tCBDef, "saveFilter"));
   }
   return false;
}

FilterEditor.prototype.getDisplayPath = function(sPath)
{
   return CatalogBrowser.getCatalogDisplayPath(sPath);
}

//-------------------
FilterEditor.prototype.applyBrowser = function(eid, bOverWrite)
{
   try
   {
      var tFilter = this.getFilterElement();
      var sFilterXml = tFilter == null ? "" : saw.getXmlText(tFilter);
      SaveBrowser.applyBrowser(eid, bOverWrite, sFilterXml, "SaveFilter", true);
   }
   catch (x)
   {
      var tBrowser = XUIPanel.getEditor("idBrowser");
      tBrowser.restore();
   }
}

//-------------------
FilterEditor.prototype.onSaveSuccess = function(eid)
{
// not sure why save success needs to close the browser...it should happen automagically
   //var tBrowser = XUIPanel.getEditor("idBrowser");
   //tBrowser.panel.close();

   if (typeof(ReportPageEditor) != "undefined")
   {
   /* fliang 3/3/05 CR:12-TOGZ5N
   // OK, now replace the filter with the saved filter.
      var tFilter = this.getFilterElement();
      var sPath = this.form.Folder.value + "/" + escapechar(this.form.ItemName.value,'/',true);
      XUIRemoveAllChildren(tFilter);

      var tExpr = FilterEditor.appendExpr(tFilter, saw.xml.kSawNamespace, "savedFilter");
      XUISetAttributeString(tExpr, "path", sPath);
      XUISetAttributeString(tExpr, "name", this.form.ItemName.value);

      // Show the filter
      this.displayFilter();
   */
      // Show the subject area panel again
      parent.frames["picker"].location.reload(true);
   }
   else
   {
      var tNameCell = document.getElementById("idNameCell");
      tNameCell.innerHTML = saw.encodeHTML(this.form.ItemName.value);
   }
}

//-------------------
FilterEditor.prototype.clickListRequalify = function(bChecked)
{
   if (bChecked)
   {
      // check if the filter has a SqlExpression for the segment.segmentPredicate already
      var tFilter = this.getFilterElement(true);
      var tExpressions = tFilter.selectNodes (".//sawx:expr[@xsi:type='sawx:sql']");

      var bCreateNewPredicate = true;
      if (null != tExpressions)
      {
         //var tExpr = tExpressions.nextNode;
         for (var i = 0; i < tExpressions.length; i++)
         {
            if (XUIGetElementText(tExpressions[i]) == "@{segment.segmentPredicate}{0=1}")
            {
               bCreateNewPredicate = false;
               break;
            }

            //tExpr = tExpressions.nextNode;
         }
      }

      // create a new predicate if necessary
      if (bCreateNewPredicate)
      {
         var newExpr = XUICreateElement (saw.xml.kSawxNamespace, "expr");
         XUISetXsiType(newExpr, saw.xml.kSawxNamespace, "sql");
         XUISetElementText(newExpr, "@{segment.segmentPredicate}{0=1}");

         if (!tFilter.hasChildNodes())
         {
            tFilter.appendChild(newExpr);
         }
         else if (XUIGetXsiType(saw.getFirstChildElement(tFilter)) == "logical")
         {
            saw.getFirstChildElement(tFilter).appendChild(newExpr);
         }
         else // create a logical and and add this expr
         {
            var tCurrent = saw.getFirstChildElement(tFilter);
            tFilter.removeChild(tCurrent);
            var tAnd = FilterEditor.appendExpr(tFilter, saw.xml.kSawxNamespace, "logical", "and");
            tAnd.appendChild(tCurrent);

            tAnd.appendChild(newExpr);
         }

         this.displayFilter();
      }

      // add the template attributes to the criteria only if primarily derived
      XUISetAttributeString (this.criteria, "templateForEach", "segments");
      XUISetAttributeString (this.criteria, "templateIterator", "segment");
      XUISetAttributeString (this.criteria, "templateSetOp", "union");


   }
   else
   {
      // find and remove the SqlExpression for the segment.segmentPredicate
      var tFilter = this.getFilterElement(true);
      var tExpressions = tFilter.selectNodes (".//sawx:expr[@xsi:type='sawx:sql']");

      if (null != tExpressions)
      {
         //var tExpr = tExpressions.nextNode;
         for (var i = 0; i < tExpressions.length; i++)
         {
            if (XUIGetElementText(tExpressions[i]) == "@{segment.segmentPredicate}{0=1}")
            {
               // delete would redraw
               this.deleteFilter (tExpressions[i]);
               break;
            }

            //tExpr = tExpressions.nextNode;
         }
      }

      // remove the segment-specific template attributes in the criteria
      if (XUIGetAttributeString (this.criteria, "templateForEach", "") == "segments")
         XUISetOrRemoveAttributeString (this.criteria, "templateForEach");

      if (XUIGetAttributeString (this.criteria, "templateIterator", "") == "segment")
         XUISetOrRemoveAttributeString (this.criteria, "templateIterator");

      if (XUIGetAttributeString (this.criteria, "templateSetOp", "") == "union")
         XUISetOrRemoveAttributeString (this.criteria, "templateSetOp");

   }
}

////////////////////////////////////////////////////////////////////////////////////////////
//-------------------
function LoadSavedFilter(sPath)
{
   var tApplyFilterEditor = XUIPanel.getEditor('idFilterApply');
   return (tApplyFilterEditor.loadSavedFilter(sPath));
}

//-------------------
FilterEditor.onClickListRequalify = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);
   var bChecked = tEditor.listFormatForm.listRequalify.checked;

   var tRequalifiedCriteria = null;
   // if the flag is being checked and
   // if a derived criteria, check if an existing criterion has been requalified already
   // if so, prompt the user
   if (bChecked && tEditor.parentEditor.isPrimarilyDerived () &&
       null != (tRequalifiedCriteria = tEditor.getRequalifiedCriteria ()))
   {
      // uncheck before reconfirmation
      tEditor.listFormatForm.listRequalify.checked = false;

      // keep track of the other criteria
      tEditor.requalifyConfirmDlg.requalifiedCriteria = tRequalifiedCriteria;

      var tDialog = new XUIDialog ('idRequalifyConfirmDlg', tEditor.requalifyConfirmDlg, tEditor);
      //tDialog.show (null, -1, -1, null, null, true);
      tDialog.show (null, -1, -1);
      return;
   }

   // check/uncheck the flag
   tEditor.clickListRequalify (bChecked);
}

//-------------------
FilterEditor.onClickIgnoreListRequalifyCheckError = function(eid)
{
   var tEditor = XUIPanel.getEditor (eid);

   tEditor.listRequalifyCheckErrorTable.style.display = 'none';
   tEditor.listRequalifyCheckErrorCell.innerHTML = "";
}

//-------------------
// Used to test if AggByFilterDlg is open AND if so, to return the editor
// for putting the aggregate by formula
FilterEditor.prototype.getActiveAggByFilterEditor = function()
{
   if (XUIDialog.isVisible('idAggByFilter') == false)
      return null;

   return XUIPanel.getEditor('idAggByFilter');
}

// Used to test if ColumnFilter dialog is open
FilterEditor.prototype.getActiveColumnFilterEditor = function()
{
   if (XUIDialog.isVisible('idColumnFilter') == false)
      return null;

   return XUIPanel.getEditor('idColumnFilter');
}

//used to replace expanded saved filters with their new content.
FilterEditor.prototype.reduceSavedFilters = function()
{
   var vSavedFilters = this.criteria.selectNodes (".//sawx:expr[@xsi:type='saw:savedFilter']");
   for (var i=0; i<vSavedFilters.length; i++)
   {
      var tSavedFilter = vSavedFilters[i];
      var tParent = tSavedFilter.parentNode;
      var tExpandedExpr = tSavedFilter.selectSingleNode("saw:filter/sawx:expr");

      if (XUIGetAttributeString(tSavedFilter,"changed") == "true" && tExpandedExpr)
      {
         tParent.replaceChild(tExpandedExpr, tSavedFilter);
      }
   }
}

//-------------------
FilterEditor.onMenuProtect = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);
   var tExpr = saw.activeMenu.expr;

   if (XUIGetAttributeBool(tExpr, "protected"))
      tExpr.removeAttribute("protected");
   else
      XUISetAttributeBool(tExpr, "protected", true);

   saw.clearActiveMenu();
}

////////////////////////////////////////////////////////////////////////////////

FilterEditor.getDataToDisplayTZOffset = function(tExpr)
{
   if (tExpr.parentNode != null)
   {
      var tColumnExpr = saw.getFirstChildElement(tExpr.parentNode);
      if (tColumnExpr != null)
      {
         var sFormula = XUIGetElementText(tColumnExpr);
         var sColumnID = null;
         if (sFormula == null || sFormula == '')
         {
            sFormula = null;
            sColumnID = tColumnExpr.getAttribute('columnID');
         }
         var tInfo = XUIColumnSpace.findInfo(sColumnID, sFormula);
         if (tInfo != null && XUIColumnSpace.getInfoSQLAttr(tInfo, "primaryType") == 'timeStamp')
         {
	         var sDataTZOffset = XUIColumnSpace.getInfoSQLAttr(tInfo, "timeZone");
	         var tCriteria = tExpr.parentNode;
	         while (tCriteria != null && tCriteria.nodeName != 'saw:criteria')
	            tCriteria = tCriteria.parentNode;

            //used when apply saved filters. In this case criteria doesn't contain columns, we the primary criteria in the report
            if (tCriteria == null || tCriteria.selectSingleNode("saw:columns") == null)
	            tCriteria = XUIGetRootXML().selectSingleNode("saw:report/saw:criteria");
	            
	         if (tCriteria != null)
	         {
	            var sDisplayTZ = saw.tz.getDisplayTimeZone(tInfo, tCriteria);
	            return -saw.tz.getDisplayToDataTZOffset(tInfo, sDisplayTZ);
	         }
         }
      }
   }
   
   return 0;
}
